import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:growing_sunflower_stage0', {
        onRandomTick: ({ block }) => {
            const stage = block.permutation.withState("v360:growing", 1)
            block.setPermutation(stage)
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:growing_sunflower_stage1', {
        onRandomTick: ({ block }) => {
            block.setType('minecraft:double_plant')
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:growing_sunflower_bonemeal0', {
        onPlayerInteract({ block, player }) {
            const { x, y, z } = block.location
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            const stage = block.permutation.withState("v360:growing", 1);
            if (selectedItem?.typeId === 'minecraft:bone_meal') {
                block.setPermutation(stage)
                block.dimension.playSound('item.bone_meal.use', block.location)
                player.runCommandAsync('clear @s minecraft:bone_meal 0 1')
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:growing_sunflower_bonemeal1', {
        onPlayerInteract({ block, player }) {
            const { x, y, z } = block.location
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (selectedItem?.typeId === 'minecraft:bone_meal') {
                block.setType('minecraft:double_plant')
                block.dimension.playSound('item.bone_meal.use', block.location)
                player.runCommandAsync('clear @s minecraft:bone_meal 0 1')
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }
        }
    })
})